"""
===============================================================================
    Projekt: Moduláris Esőkert Számítási Programok
    Fejlesztő: Glia Kutatás - Fejlesztési Innovációs Kft.
    Weboldal: www.glia.hu
    Verzió: 1.0
    Dátum: 2018
    Licenc: Nyílt forráskódú szoftver (MIT Licenc)

    Pályázati támogatás:
    Ez a fejlesztés a GINOP-2.1.7-15-2016-02435 pályázat keretén belül 
    valósult meg, amely célja a moduláris beton-műanyag kompozit szikkasztó 
    rendszer fejlesztése volt és a Glia Kft. tarnabodi telephelyén került megvalósításra.

    Leírás:
    Ez a program a moduláris esőkert különböző hidrológiai paramétereinek 
    számítására szolgál. Tartalmazza az alábbi funkciókat:
    - Kapilláris vízemelés számítása
    - Infiltráció és vízbeszivárgás számítása
    - Vízmozgás sebességének becslése
    - Párolgás és evapotranszspiráció számítása
    - Esőkert tározási kapacitás és túlcsordulás vizsgálata

    Licencfeltételek:
    Ez a szoftver az MIT Licenc alatt áll, így szabadon másolható, módosítható 
    és terjeszthető, feltéve hogy a fent megnevezett fejlesztői jogokat 
    és a licencfeltételeket tiszteletben tartják.
===============================================================================
"""OD

import argparse

def soil_water_capacity(field_capacity, soil_volume):
    """
    Talaj mezőgazdasági vízkapacitásának (FC), hervadási pontjának (WP) és 
    hasznosítható vízkészletének (AWC) számítása.

    Paraméterek:
        field_capacity (float): Mezőgazdasági vízkapacitás (dimenzió nélküli, 0 és 1 között)
        soil_volume (float): Talaj térfogata (m³)

    Visszatérés:
        dict: Számított vízmennyiségek (m³)
    """
    # Mezőgazdasági vízkapacitás (FC)
    FC_m3 = field_capacity * soil_volume  # Összes vízmennyiség m³-ben

    # Hervadási pont (WP) = FC * 0.5 (általános közelítés)
    WP_m3 = FC_m3 * 0.5

    # Hasznosítható vízkészlet (AWC) = FC - WP
    AWC_m3 = FC_m3 - WP_m3

    return {
        "Mezőgazdasági vízkapacitás (FC)": FC_m3,
        "Hervadási pont (WP)": WP_m3,
        "Hasznosítható vízkészlet (AWC)": AWC_m3
    }

def main():
    """
    A program fő része, amely parancssori argumentumokat dolgoz fel,
    és kiszámolja a talaj víztartó képességét.
    """
    parser = argparse.ArgumentParser(description="Talaj víztartó képességének számítása.")

    # Parancssori argumentumok meghatározása
    parser.add_argument("--field_capacity", type=float, required=True, help="Mezőgazdasági vízkapacitás (0 és 1 között)")
    parser.add_argument("--soil_volume", type=float, required=True, help="Talaj térfogata (m³)")

    # Argumentumok beolvasása
    args = parser.parse_args()

    # Számítások végrehajtása
    results = soil_water_capacity(args.field_capacity, args.soil_volume)

    # Eredmények kiírása
    print("\n📊 Talaj víztartó képesség számítás eredményei:")
    print(f"🌱 Mezőgazdasági vízkapacitás (FC): {results['Mezőgazdasági vízkapacitás (FC)']:.2f} m³")
    print(f"🥀 Hervadási pont (WP): {results['Hervadási pont (WP)']:.2f} m³")
    print(f"💧 Hasznosítható vízkészlet (AWC): {results['Hasznosítható vízkészlet (AWC)']:.2f} m³")

if __name__ == "__main__":
    main()
