# Python program for rain garden sizing calculations

def calculate_rain_garden(v_ff, d_rg, k, h, t_rg):
    """
    Számítja az esőkert szűrőfelületét (filtrációs terület) és a kiterjesztett visszatartási területet.

    Paraméterek:
    v_ff (float): Az első öblítés térfogata (m³)
    d_rg (float): Szűrőréteg vastagsága (m)
    k (float): Áteresztőképességi együttható (mm/h)
    h (float): Vízoszlop átlagos magassága (m)
    t_rg (float): Az az idő, amely alatt a víz áthalad a talajon (nap)

    Visszatérési érték:
    (A_rg, A_EDD) : Számított szűrőfelület és kiterjesztett visszatartási terület (m²)
    """
    # Szűrőfelület kiszámítása
    A_rg = 41.67 * (v_ff * d_rg) / (k * (h + d_rg) * t_rg)

    # Kiterjesztett visszatartási terület kiszámítása
    A_EDD = (0.4 * v_ff) / (2 * h)

    return A_rg, A_EDD

# Példa bemeneti adatok (testreszabható)
v_ff = 88.0  # Az első öblítés térfogata (m³)
d_rg = 0.6   # Szűrőréteg vastagsága (m)
k = 30       # Áteresztőképesség (mm/h)
h = 0.15     # Vízoszlop átlagos magassága (m)
t_rg = 1.0   # Időtartam (nap)

# Számítások elvégzése
A_rg, A_EDD = calculate_rain_garden(v_ff, d_rg, k, h, t_rg)

# Eredmények megjelenítése
import ace_tools as tools
import pandas as pd

# Eredmények táblázatos megjelenítése
df_results = pd.DataFrame({
    "Paraméter": ["Szűrőfelület (m²)", "Kiterjesztett visszatartási terület (m²)"],
    "Érték": [A_rg, A_EDD]
})

tools.display_dataframe_to_user(name="Esőkert méretezési eredmények", dataframe=df_results)
