"""
===============================================================================
    Projekt: Moduláris Esőkert Számítási Programok
    Fejlesztő: Glia Kutatás - Fejlesztési Innovációs Kft.
    Weboldal: www.glia.hu
    Verzió: 1.0
    Dátum: 20??
    Licenc: Nyílt forráskódú szoftver (MIT Licenc)

Pályázati támogatás:
    Ez a fejlesztés a GINOP-2.1.7-15-2016-02435 pályázat keretén belül 
    valósult meg, amely célja a moduláris beton-műanyag kompozit szikkasztó 
    rendszer fejlesztése volt támogatásban részesült, és a Glia Kft. tarnabodi telephelyén került megvalósításra.

    Leírás:
    Ez a program a moduláris esőkert különböző hidrológiai paramétereinek 
    számítására szolgál. Tartalmazza az alábbi funkciókat:
    - Kapilláris vízemelés számítása
    - Infiltráció és vízbeszivárgás számítása
    - Vízmozgás sebességének becslése
    - Párolgás és evapotranszspiráció számítása
    - Esőkert tározási kapacitás és túlcsordulás vizsgálata

    Licencfeltételek:
    Ez a szoftver az MIT Licenc alatt áll, így szabadon másolható, módosítható 
    és terjeszthető, feltéve hogy a fent megnevezett fejlesztői jogokat 
    és a licencfeltételeket tiszteletben tartják.
===============================================================================
"""


import argparse

def rain_garden_storage(area, depth, water_content):
    """
    Kiszámítja az esőkert teljes víztározási kapacitását.

    Paraméterek:
        area (float): Esőkert felszíni területe (m²)
        depth (float): Talajréteg mélysége (m)
        water_content (float): Talaj tényleges víztartalma (dimenzió nélküli)

    Visszatérés:
        float: Az esőkert tározási kapacitása (m³)
    """
    storage_capacity = area * depth * water_content
    return storage_capacity

def main():
    """
    A program fő része, amely parancssori argumentumokat dolgoz fel,
    és kiszámolja az esőkert víztározási kapacitását.
    """
    parser = argparse.ArgumentParser(description="Esőkert tározási kapacitásának számítása.")

    # Parancssori argumentumok meghatározása
    parser.add_argument("--area", type=float, required=True, help="Esőkert felszíni területe (m²)")
    parser.add_argument("--depth", type=float, required=True, help="Talajréteg mélysége (m)")
    parser.add_argument("--water_content", type=float, required=True, help="Talaj tényleges víztartalma (dimenzió nélküli)")

    # Argumentumok beolvasása
    args = parser.parse_args()

    # Számítás végrehajtása
    storage_capacity = rain_garden_storage(args.area, args.depth, args.water_content)

    # Eredmény kiírása
    print("\n📊 Esőkert Tározási Kapacitás számítás:")
    print(f"🌿 Tárolható vízmennyiség: {storage_capacity:.2f} m³")

if __name__ == "__main__":
    main()
